% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssertCollection.R
\name{AssertCollection}
\alias{AssertCollection}
\alias{makeAssertCollection}
\alias{reportAssertions}
\title{Collect multiple assertions}
\usage{
makeAssertCollection()

reportAssertions(collection)
}
\arguments{
\item{collection}{[\code{AssertCollection}]\cr
Object of type \dQuote{AssertCollection} (constructed via \code{makeAssertCollection}).}
}
\value{
\code{makeAssertCollection()} returns an object of class \dQuote{AssertCollection} and
 \code{reportCollection} returns invisibly \code{TRUE} if no error is thrown (i.e., no message was
 collected).
}
\description{
The function \code{makeAssertCollection()} returns a simple stack-like
closure you can pass to all functions of the \code{assert*}-family.
All messages get collected and can be reported with \code{reportAssertions()}.
Alternatively, you can easily write your own report function or customize the the output of
the report function to a certain degree.
See the example on how to push custom messages or retrieve all stored messages.
}
\examples{
x = "a"
coll = makeAssertCollection()

print(coll$isEmpty())
assertNumeric(x, add = coll)
coll$isEmpty()
coll$push("Custom error message")
coll$getMessages()
\dontrun{
  reportAssertions(coll)
}
}

