% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkOS.r
\name{checkOS}
\alias{assertOS}
\alias{assert_os}
\alias{checkOS}
\alias{expect_os}
\alias{testOS}
\alias{test_os}
\title{Check the operating system}
\usage{
checkOS(os)

assertOS(os, add = NULL, .var.name = NULL)

assert_os(os, add = NULL, .var.name = NULL)

testOS(os)

test_os(os)

expect_os(os, info = NULL, label = NULL)
}
\arguments{
\item{os}{[\code{character(1)}]\cr
Check the operating system to be in a set with possible elements \dQuote{windows},
\dQuote{mac}, \dQuote{linux} and \dQuote{solaris}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertOS}/\code{assert_os}
 throws an error message, \code{testOS}/\code{test_os}
 returns \code{FALSE},
 and \code{checkOS} returns a string with the error message.
 The function \code{expect_os} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check the operating system
}
\examples{
testOS("linux")
}

