% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkInteger}
\alias{assertInteger}
\alias{checkInteger}
\alias{testInteger}
\title{Check if an argument is vector of type integer}
\usage{
checkInteger(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL)

assertInteger(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL, .var.name)

testInteger(x, lower = -Inf, upper = Inf, any.missing = TRUE,
  all.missing = TRUE, len = NULL, min.len = NULL, max.len = NULL,
  unique = FALSE, names = NULL)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertInteger} throws an error message,
 \code{testInteger} returns \code{FALSE} and \code{checkInteger} returns
 a string with the error message.
}
\description{
Check if an argument is vector of type integer
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testInteger(1L)
testInteger(1.)
testInteger(1:2, lower = 1, upper = 2, any.missing = FALSE)
}
\seealso{
\code{\link{asInteger}}

Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{testAtomic}}; \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{testComplex}};
  \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{testDataFrame}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFactor}}, \code{\link{checkFactor}},
  \code{\link{testFactor}}; \code{\link{assertFunction}},
  \code{\link{checkFunction}}, \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{testIntegerish}}; \code{\link{assertList}},
  \code{\link{checkList}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{testLogical}}; \code{\link{assertMatrix}},
  \code{\link{checkMatrix}}, \code{\link{testMatrix}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{testNumeric}}; \code{\link{assertVector}},
  \code{\link{checkVector}}, \code{\link{testVector}}
}

