% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateImage4R.R
\name{generateImage4R}
\alias{generateImage4R}
\title{Generate Text to Images Using OpenAI API}
\usage{
generateImage4R(
  content,
  n = 3,
  size = "256x256",
  response_format = "url",
  Output_image = TRUE,
  SaveImg = FALSE,
  api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{content}{A character string, the content to generate images.}

\item{n}{A count, the number of images to generate. Must be between 1 and 10.}

\item{size}{A character string, the size of the images. Must be one of "256x256", "512x512", "1024x1024".}

\item{response_format}{A character string, the format of the response from the API. Must be one of "url", "b64_json".}

\item{Output_image}{A flag, whether to output the images.}

\item{SaveImg}{A flag, whether to save the images.}

\item{api_key}{A character string, the API key for OpenAI.}
}
\value{
If Output_image is TRUE, returns a list of images; if Output_image is FALSE, returns a character vector of URLs.
}
\description{
This function generates images from text input using OpenAI API.
}
\details{
Generate Text to Images Using OpenAI API
}
\examples{
\dontrun{
# Generate images
results <- generateImage4R(content = "Japanese gal girl", n = 3)
# Display the generated images
Display(results)
}
}
\author{
Satoshi Kume
}
