% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoints.R
\docType{methods}
\name{bbmod_method}
\alias{bbmod_method}
\alias{bbmod_method,changepointsMod-method}
\title{Wrapper method for black-box estimation.}
\usage{
bbmod_method(object, part, tau)

\S4method{bbmod_method}{changepointsMod}(object, part, tau)
}
\arguments{
\item{object}{Corresponding \code{changepointsMod} class.}

\item{part}{Index for current partition, should be 1 or 2.}

\item{tau}{Current change-point.  Should be between buff and N - buff.}
}
\value{
An updated version of the change-point model.  There are currently three
        possible updates depending on the form of the \code{part_values} and
        \code{whole_values} provided.  1) If only \code{part_values} are provided,
        then we assume the black-box method only updates \code{part_values.}
        2) If only \code{whole_values} are provide, we assume the black-box
        method only updates \code{whole_values}. 3) If both \code{part_values}
        and \code{whole_values} are provided, we assume that both are updated.
}
\description{
Applies the black-box estimator to the specified partition given
             the current tau value.  Additionally, this wrapper handles the
             different data structures possible for \code{part_values} and
             \code{whole_values}.
}
\author{
\packageMaintainer{changepointsHD}
}
