% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{local.refine.network}
\alias{local.refine.network}
\title{Local refinement for network change points detection.}
\usage{
local.refine.network(
  cpt_init,
  data_mat1,
  data_mat2,
  self = FALSE,
  tau2,
  tau3 = Inf
)
}
\arguments{
\item{cpt_init}{A \code{integer} vector of initial change points estimation (sorted in strictly increasing order).}

\item{data_mat1}{A \code{numeric} matrix of observations with with horizontal axis being time, and with each column be the vectorized adjacency matrix.}

\item{data_mat2}{A independent copy of data_mat1.}

\item{self}{A \code{logic} scalar indicating if adjacency matrices are required to have self-loop.}

\item{tau2}{A positive \code{numeric} scalar for USVT corresponding to the threshold for singular values of input matrix.}

\item{tau3}{A positive \code{numeric} scalar for USVT corresponding to the threshold for entries of output matrix.}
}
\value{
A \code{numeric} vector of locally refined change point locations.
}
\description{
Perform local refinement for network change points detection.
}
\examples{
p = 15 # number of nodes
rho = 0.5 # sparsity parameter
block_num = 3 # number of groups for SBM
n = 100 # sample size for each segment
# connectivity matrix for the first and the third segments
conn1_mat = rho * matrix(c(0.6,1,0.6,1,0.6,0.5,0.6,0.5,0.6), nrow = 3) 
# connectivity matrix for the second segment
conn2_mat = rho * matrix(c(0.6,0.5,0.6,0.5,0.6,1,0.6,1,0.6), nrow = 3) 
set.seed(1)
can_vec = sample(1:p, replace = FALSE) # randomly assign nodes into groups
sbm1 = simu.SBM(conn1_mat, can_vec, n, symm = TRUE, self = TRUE)
sbm2 = simu.SBM(conn2_mat, can_vec, n, symm = TRUE, self = TRUE)
data_mat = cbind(sbm1$obs_mat, sbm2$obs_mat)
data_mat1 = data_mat[,seq(1,ncol(data_mat),2)]
data_mat2 = data_mat[,seq(2,ncol(data_mat),2)]
M = 10
intervals = WBS.intervals(M = M, lower = 1, upper = ncol(data_mat1))
temp = WBS.network(data_mat1, data_mat2, 1, ncol(data_mat1), intervals$Alpha, 
                   intervals$Beta, delta = 5)
rho_hat = quantile(rowMeans(data_mat), 0.95)
tau = p*rho_hat*(log(n))^2/20 # default threshold given in the paper
cpt_init = unlist(thresholdBS(temp, tau)$cpt_hat[,1])
cpt_refined = local.refine.network(cpt_init, data_mat1, data_mat2, self = TRUE, 
                                   tau2 = p*rho_hat/3, tau3 = Inf)
cpt_WBS = 2*cpt_init
cpt_refined = 2*cpt_refined
}
\references{
Wang, Yu and Rinaldo (2018) <arxiv:1809.09602>.
}
\author{
Daren Wang & Haotian Xu
}
