% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics_calculation.R
\name{changeTest}
\alias{changeTest}
\title{A test showing whether two datasets have similar linear structure}
\usage{
changeTest(x1, y1, x2, y2, l = NULL, kappa = 1000, trustLevel = 0.05,
  gamma = 0.5)
}
\arguments{
\item{x1}{matrix of first period regressors with variables in columns and observations in rows}

\item{y1}{matrix of first period responses with variables in columns and observations in rows}

\item{x2}{matrix of second period regressors with variables in columns and observations in rows}

\item{y2}{matrix of second period responses with variables in columns and observations in rows}

\item{l}{approximate number of contributing variables (default: overall number of regressors)}

\item{kappa}{number of bootstrap rounds (default: `1000`)}

\item{trustLevel}{trust level for bootstrap (default: `0.05`)}

\item{gamma}{tao reduction rate (default: `0.5`)}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
The function performs a nonparametric test showing whether two datasets have similar linear structure or not. The test is based on applying energy distance \insertCite{rizzo-szekely10}{changedetection} to residuals estimated for each dataset separately but only by one model (either first or second). It is implemented as a permutation test with \code{kappa} rounds and corresponding \code{trustLevel} \insertCite{gorskikh17}{changedetection}.
}
\examples{
T<-60
change<-35
x<-rnorm(n=T, m=0, sd=1)
e<-scale(rt(n=T,3), scale=FALSE)
y1<-5*x[1:(change-1)]+e[1:(change-1)]
y2<--2*x[change:T]+e[change:T]
y<-c(y1,y2)

testResult <- changeTest(x1=as.data.frame(x[1:T]),
                         y1=as.data.frame(y[1:T]),
                         x2=as.data.frame(x[31:T]),
                         y2=as.data.frame(y[31:T]),
                         kappa=100)

}
\references{
\insertAllCited
}
