% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_PE.R
\name{calc_PE}
\alias{calc_PE}
\title{Calculate phylogenetic endemism}
\usage{
calc_PE(phylo.tree, sites_x_tips, presence = NULL)
}
\arguments{
\item{phylo.tree}{class phylo object of phylogenetic tree. The names on tree's tip labels need to match the column names on the matrix}

\item{sites_x_tips}{class data.frame object. Rows should be locations and columns should be species. The sites should represent equal areas (presumably grid cells). There is no need to include unoccupied grid cells.  One easy way to get this, is to simply round the coordinates to the appropriate grid resolution, and then group occurrences at the same rounded location together using aggregate or dplyr}

\item{presence}{character string of either: "presence", "abundance", or "probability".
presence specifies what the values in the matrix cells mean, and how to calculate PE
abundance is an amount (could be number of individuals, proportion of cell occupied etc).  With abundance, PE is equivalent to Caddotte & Davies BED)
probability is a value from 0 to 1, for example from an SDM.  Probability then propagates to internal branches at the probability that any of the descendent branches are present.  This method is described in a paper of mine in, which is being pending minor revisions.}
}
\value{
dataframe showing the PE at each site
}
\description{
Calculates phylogenetic endemism from a tree and a sites by tips (species) matrix.
}
\examples{
## Convert raster stack to points
r1 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r1)<- runif(n = (108*108))
r1[r1 < 0.5] <- NA
r1[r1 > 0.5] <- 1
r2 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r2)<- runif(n = (108*108))
r2[r2 < 0.5] <- NA
r2[r2 > 0.5] <- 1
r3 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r3)<- runif(n = (108*108))
r3[r3 < 0.5] <- NA
r3[r3 > 0.5] <- 1
rStack <- raster::stack(r1, r2, r3)
Allxy <- raster::rasterToPoints(rStack)
# Drop first 2 columns (lat/long)
sites <- Allxy[,2:ncol(Allxy)]
sites[is.na(sites)] <- 0
library(ape)
tree <- rtree(n = 3)
tree$tip.label <- names(rStack)
calc_PE(phylo.tree = tree, sites_x_tips = sites, presence = "presence")
}
