% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgr_generic.R
\name{plot.cgrcusum}
\alias{plot.cgrcusum}
\alias{plot.bkcusum}
\alias{plot.funnelplot}
\alias{plot.bercusum}
\title{Plot a quality control chart}
\usage{
\method{plot}{cgrcusum}(x, h, ...)

\method{plot}{bkcusum}(x, h, ...)

\method{plot}{funnelplot}(x, percentage = TRUE, ...)

\method{plot}{bercusum}(x, h = x$h, ...)
}
\arguments{
\item{x}{chart to plot}

\item{h}{control limit to display for 'cgrcusum', 'bkcusum' or 'bercusum'}

\item{...}{further plotting parameters}

\item{percentage}{Should output be shown in percentages?}
}
\value{
A plot of the associated chart is displayed in the current graphics device.
}
\description{
Plot a 'cgrcusum', 'bkcusum', 'bercusum' or 'funnelplot' chart.
}
\section{Methods (by class)}{
\itemize{
\item \code{cgrcusum}: Plot a CGR-CUSUM

\item \code{bkcusum}: Plot a BK-CUSUM

\item \code{funnelplot}: Plot a funnelplot

\item \code{bercusum}: Plot a Bernoulli CUSUM
}}

\seealso{
\code{\link[cgrcusum]{cgrcusum}}, \code{\link[cgrcusum]{bkcusum}}, \code{\link[cgrcusum]{bercusum}}, \code{\link[cgrcusum]{funnelplot}}
}
\author{
Daniel Gomon
}
