% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg_add_parms}
\alias{cg_add_parms}
\title{Add Parameters}
\arguments{
\item{...}{numeric vectors or arrays, the values of the parameters. Is ignored when \code{parms} is not \code{NULL}.}

\item{parms}{named list, the parameters that are to be added to the graph.}
}
\value{
nothing.
}
\description{
Add parameters to the graph.
}
\details{
\code{$add_parms(..., parms = NULL)}
}
\note{
Parameters can be named by providing named arguments to \code{...} or by naming the elements of argument \code{parms}. In case no names are provided, parameters are tried to be added to the graph under an auto-generated name. No default value is set for parameters with value \code{NULL}.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add some parameters.
x$add_parms(prm1 = 1, prm2 = 2, prm3 = 3)

# List the parameters.
x$get_parms()

}
\author{
Ron Triepels
}
