% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEncoding.R
\name{get_encoding}
\alias{get_encoding}
\title{Extract the computed encoding}
\usage{
get_encoding(x, harm = 1, fdObject = FALSE, nx = NULL)
}
\arguments{
\item{x}{Output of \code{\link{compute_optimal_encoding}}}

\item{harm}{harmonic to use for the encoding}

\item{fdObject}{If TRUE returns a \code{fd} object else a matrix}

\item{nx}{(Only if \code{fdObject = TRUE}) Number of points to evaluate the encoding}
}
\value{
a \code{fd} object or a list of two elements \code{y}, a matrix with \code{nx} rows containing the encoding of the state and \code{x}, the vector with time values.
}
\description{
Extract the encoding as an \code{fd} object or as a matrix
}
\details{
The encoding is \eqn{a_{x} \approx \sum_{i=1}^m \alpha_{x,i}\phi_i}.
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement 
K <- 4
Tmax <- 6
PJK <- matrix(1/3, nrow = K, ncol = K) - diag(rep(1/3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = Tmax)
d_JK2 <- cut_data(d_JK, Tmax)

# create basis object
m <- 6
b <- create.bspline.basis(c(0, Tmax), nbasis = m, norder = 4)

\donttest{
# compute encoding
encoding <- compute_optimal_encoding(d_JK2, b, computeCI = FALSE, nCores = 1)

# extract the encoding using 1 harmonic
encodFd <- get_encoding(encoding, fdObject = TRUE)
encodMat <- get_encoding(encoding, nx = 200)
}

}
\author{
Cristian Preda
}
