% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_recruiting.R
\name{cfbd_recruiting_player}
\alias{cfbd_recruiting_player}
\title{\strong{Get player recruiting rankings}}
\usage{
cfbd_recruiting_player(
  year = NULL,
  team = NULL,
  recruit_type = "HighSchool",
  state = NULL,
  position = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}) - Minimum: 2000, Maximum: 2020 currently}

\item{team}{(\emph{String} optional): D-I Team}

\item{recruit_type}{(\emph{String} optional): default API return is 'HighSchool', other options include 'JUCO'
or 'PrepSchool'  - For position group information}

\item{state}{(\emph{String} optional): Two letter State abbreviation}

\item{position}{(\emph{String} optional): Position Group  - options include:
\itemize{
\item Offense: 'PRO', 'DUAL', 'RB', 'FB', 'TE',  'OT', 'OG', 'OC', 'WR'
\item Defense: 'CB', 'S', 'OLB', 'ILB', 'WDE', 'SDE', 'DT'
\item Special Teams: 'K', 'P'
}}
}
\value{
\code{\link[=cfbd_recruiting_player]{cfbd_recruiting_player()}} - A data frame with 14 variables:
\describe{
\item{\code{id}: integer.}{Referencing id - 247Sports.}
\item{\code{athlete_id}}{Athlete referencing id.}
\item{\code{recruit_type}: character.}{High School, Prep School, or Junior College.}
\item{\code{year}: integer.}{Recruit class year.}
\item{\code{ranking}: integer.}{Recruit Ranking.}
\item{\code{name}: character.}{Recruit Name.}
\item{\code{school}: character.}{School recruit attended.}
\item{\code{committed_to}: character.}{School the recruit is committed to.}
\item{\code{position}: character.}{Recruit position.}
\item{\code{height}: double.}{Recruit height.}
\item{\code{weight}: integer.}{Recruit weight.}
\item{\code{stars}: integer.}{Recruit stars.}
\item{\code{rating}: double.}{247 composite rating.}
\item{\code{city}: character.}{Hometown of the recruit.}
\item{\code{state_province}: character.}{Hometown state of the recruit.}
\item{\code{country}: character.}{Hometown country of the recruit.}
\item{\code{hometown_info_latitude}: character.}{Hometown latitude.}
\item{\code{hometown_info_longitude}: character.}{Hometown longitude.}
\item{\code{hometown_info_fips_code}: character.}{Hometown FIPS code.}
}
}
\description{
\strong{Get player recruiting rankings}
}
\examples{
\donttest{
  try(cfbd_recruiting_player(2018, team = "Texas"))

  try(cfbd_recruiting_player(2016, recruit_type = "JUCO"))

  try(cfbd_recruiting_player(2020, recruit_type = "HighSchool", position = "OT", state = "FL"))
}

}
\keyword{Recruiting}
