% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_players.R
\name{cfbd_player_returning}
\alias{cfbd_player_returning}
\title{\strong{Get player returning production}}
\usage{
cfbd_player_returning(year = 2019, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} required, default 2019): Year, 4 digit format (\emph{YYYY}).}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference\cr
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC\cr
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_player_returning]{cfbd_player_returning()}} - A data frame with 15 variables:
\describe{
\item{\code{season}:integer.}{Returning player season.}
\item{\code{team}:character.}{Team name.}
\item{\code{conference}:character.}{Conference of team.}
\item{\code{total_ppa}:double.}{Total predicted points added returning.}
\item{\code{total_passing_ppa}:double.}{Total passing predicted points added returning.}
\item{\code{total_receiving_ppa}:double.}{Total receiving predicted points added returning.}
\item{\code{total_rushing_ppa}:double.}{Total rushing predicted points added returning.}
\item{\code{percent_ppa}:double.}{Percentage of prior year's predicted points added returning.}
\item{\code{percent_passing_ppa}:double.}{Percentage of prior year's passing predicted points added returning.}
\item{\code{percent_receiving_ppa}:double.}{Percentage of prior year's receiving predicted points added returning.}
\item{\code{percent_rushing_ppa}:double.}{Percentage of prior year's rushing predicted points added returning.}
\item{\code{usage}:double.}{.}
\item{\code{passing_usage}:double.}{.}
\item{\code{receiving_usage}:double.}{.}
\item{\code{rushing_usage}:double.}{.}
}
}
\description{
\strong{Get player returning production}
}
\examples{
\donttest{
 cfbd_player_returning(year = 2019, team = "Florida State")
}

}
\keyword{Production}
\keyword{Returning}
