% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_wp_pregame}
\alias{cfbd_metrics_wp_pregame}
\title{\strong{Get pre-game win probability data from API}}
\usage{
cfbd_metrics_wp_pregame(
  year = NULL,
  week = NULL,
  team = NULL,
  season_type = "regular"
)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{team}{(\emph{String} optional): D-I Team}

\item{season_type}{(\emph{String} default regular): Select Season Type: regular or postseason}
}
\value{
\code{\link[=cfbd_metrics_wp_pregame]{cfbd_metrics_wp_pregame()}} - A data frame with 9 variables:
\describe{
\item{\code{season}: integer.}{Season of game.}
\item{\code{season_type}: character.}{Season type of game.}
\item{\code{week}: integer.}{Game week of the season.}
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{home_team}: character.}{Home team name.}
\item{\code{away_team}: character.}{Away team name.}
\item{\code{spread}: integer.}{Betting line provider spread.}
\item{\code{home_win_prob}: double.}{Home win probability - pre-game prediction.}
\item{\code{away_win_prob}: double.}{Away win probability - pre-game prediction.}
}
}
\description{
\strong{Get pre-game win probability data from API}
}
\examples{
\donttest{
cfbd_metrics_wp_pregame(year = 2019, week = 9, team = "Texas A&M")
}

}
\keyword{Data}
\keyword{Pre-game}
\keyword{Probability}
\keyword{Win}
