% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine_metadata.R
\name{examine_metadata}
\alias{examine_metadata}
\title{Examine Variable Metadata in a CES Dataset}
\usage{
examine_metadata(data, show_labels = FALSE, variable_pattern = NULL)
}
\arguments{
\item{data}{A CES dataset, typically retrieved using \code{get_ces()}.}

\item{show_labels}{Logical indicating whether to show the actual labels.
Default is FALSE.}

\item{variable_pattern}{Optional regular expression to filter variables.}
}
\value{
A data.frame with metadata information for each variable.
}
\description{
This function provides an overview of the metadata available in a CES dataset,
showing which variables have labels, value labels, and other attributes.
}
\examples{
\donttest{
# Get CES data with preserved metadata
ces_2019 <- get_ces("2019", preserve_metadata = TRUE)

# Examine metadata for all variables
metadata_overview <- examine_metadata(ces_2019)

# Examine metadata for voting-related variables, showing labels
voting_metadata <- examine_metadata(ces_2019, 
                                   show_labels = TRUE,
                                   variable_pattern = "vote|ballot")
}

}
