% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cernn.r
\name{select_lambda}
\alias{select_lambda}
\title{Selection of penalty parameter based on cross-validation}
\usage{
select_lambda(X, lambda, fold = min(nrow(X), 10))
}
\arguments{
\item{X}{n-by-p data matrix}

\item{lambda}{vector of penalties for cross-validation}

\item{fold}{number of folds for cross-validation}
}
\description{
\code{select_lambda} selects the best regularization parameter from a grid of values based
on minimal predictive negative log-likelihood.
}
\examples{
n <- 30
p <- 30
set.seed(12345)
X <- matrix(rnorm(n*p),n,p)
alpha <- get_alpha(X)
lambda_max <- get_lambda_max(svd(X)$d**2,alpha,n)
lambda <- 10**(seq(-1,log10(lambda_max),length.out=100))
sol_path <- cernn(X,lambda,alpha)
df <- t(sol_path$e)

## Plot regularization paths of eigenvalues
matplot(x=log10(lambda),y=df,type='l',ylab='shrunken eigenvalue')
grand_mean <- (norm(scale(X,center=TRUE,scale=FALSE),'f')**2)/(n*p)
abline(h=grand_mean)

## Plot selected lambda
abline(v=log10(select_lambda(X,lambda)$lambda))
}

