% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_last}
\alias{plot_last}
\title{Plot the last modified rule or class}
\usage{
plot_last(
  obj,
  show_feat = TRUE,
  what = "rule",
  fast = NULL,
  legend_rel_width = 0.3
)
}
\arguments{
\item{obj}{A cellpypes object, see section \strong{cellpypes Objects} below.}

\item{show_feat}{If TRUE (default), a second panel shows the feature plot of
the relevant gene.}

\item{what}{Either "rule" or "class".}

\item{fast}{Set this to TRUE if you want fast plotting in spite of many cells
(using the scattermore package). If NULL (default), cellpypes decides
automatically and fast plotting is done for more than 10k cells.}

\item{legend_rel_width}{Relative width compared to the other two plots
(only relevant if \code{show_feat=TRUE}).}
}
\value{
Returns a ggplot2 object with the plot.
}
\description{
Plot the last modified rule or class
}
\section{cellpypes Objects}{

A cellpypes object is a \link[base]{list} with four slots:
\itemize{
\item{\code{raw }}{(sparse) matrix with genes in rows, cells in columns}
\item{\code{totalUMI }}{the colSums of obj$raw}
\item{\code{embed }}{two-dimensional embedding of the cells, provided as data.frame
or tibble with two columns and one row per cell.}
\item{\code{neighbors }}{index matrix with one row per cell and k columns, where
k is the number of nearest neighbors (we recommend 15<k<100, e.g. k=50).
Here are two ways to get the neighbors index matrix:
\itemize{
\item Use \code{find_knn(featureMatrix)$idx}, where featureMatrix could be
principal components, latent variables or normalized genes (features in
rows, cells in columns).
\item use \code{as(seurat@graphs[["RNA_nn"]], "dgCMatrix")> .1} to extract
the kNN
graph computed on RNA. The \code{> .1} ensures this also works with RNA_snn,
wknn/wsnn or any other
available graph – check with \code{names(seurat@graphs)}.
}
}
}
}

\examples{
plot_last(rule(simulated_umis, "T", "CD3E",">", 1))
}
