% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioscope_plot.R
\name{bioscope_plot}
\alias{bioscope_plot}
\title{Bioenergetic Scope Plot}
\usage{
bioscope_plot(
  energetics,
  error_bar = "ci",
  conf_int = 0.95,
  size = 2,
  basal_shape = 1,
  max_shape = 19,
  group_label = "Experimental Group"
)
}
\arguments{
\item{energetics}{A table of calculated glycolysis and OXPHOS rates.
Returned by \code{get_energetics}}

\item{error_bar}{Whether to plot error bars as standard deviation (\code{"sd"})
or confidence intervals (\code{"ci"})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and 1}

\item{size}{Size of the points}

\item{basal_shape}{Shape of the points for basal values}

\item{max_shape}{Shape of the points for max values}

\item{group_label}{Label for the experimental group to populate the legend title}

\item{bioscope_plot}{Creates a 2D plot visualizing the mean and standard
deviation basal and maximal ATP production from glycolysis and OXPHOS for
each experimental group}
}
\value{
a ggplot
}
\description{
Generate the Bioenergetic Scope Plot
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
partitioned_data <- partition_data(seahorse_rates)
energetics <- get_energetics(
  partitioned_data,
  ph = 7.4,
  pka = 6.093,
  buffer = 0.1
)
bioscope_plot(energetics)

# to change fill, the geom_point shape should be between 15 and 20.
# These shapes are filled without border and will correctly show on the legend.
bioscope_plot(energetics, size = 3, basal_shape = 2, max_shape = 17) + # empty and filled triangle
  ggplot2::scale_fill_manual(
    values = c("#e36500", "#b52356", "#3cb62d", "#328fe1")
  )

# to change color, use ggplot2::scale_color_manual
bioscope_plot(energetics) +
  ggplot2::scale_color_manual(
    values = c("#e36500", "#b52356", "#3cb62d", "#328fe1")
  )
}
