% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDL.R
\name{getCDL}
\alias{getCDL}
\title{Get CDL raster data}
\usage{
getCDL(x, year, alternativeUrl, location, https = TRUE,
  ssl.verifypeer = TRUE)
}
\arguments{
\item{x}{Is either a two digit state FIPS code, a two letter abbreviation, or
a state name.}

\item{year}{A numerical vector. A set of years of CDL data to download.}

\item{alternativeUrl}{An optional string containing an alternative url.}

\item{location}{An optional string containing a location to store the file.}

\item{https}{An optional boolean to turn on and off https, default is on.}

\item{ssl.verifypeer}{An optional boolean to turn on and off ssl verfication, default is on.}
}
\value{
A list of CDL raster objects of interested county for a set of years.
}
\description{
\code{getCDL} retrieves CDL state raster objects for a set of years.
}
\examples{
\dontrun{
# Get data for California, 2013 and 2015
# by FIPS
getCDL(6,c(2013,2015))
# Get data for California, 2013 and 2015
getCDL("California",c(2013,2015))
# Get all the west coast from 2009 to 2016
getCDL(c("CA","OR","WA"),2013:2016)
}
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}

Joseph Stachelek, \email{stachel2@msu.edu}
}
