% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefOps.R, R/RowsColumns.R, R/relops.R
\name{unpivot_to_blocks}
\alias{unpivot_to_blocks}
\alias{layout_to_blocks}
\alias{pivot_to_blocks}
\alias{unpivot_to_blocks.default}
\alias{unpivot_to_blocks.relop}
\title{Map a data records from row records to block records with one record row per columnsToTakeFrom value.}
\usage{
unpivot_to_blocks(
  data,
  nameForNewKeyColumn,
  nameForNewValueColumn,
  columnsToTakeFrom,
  ...,
  nameForNewClassColumn = NULL,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  tmp_name_source = wrapr::mk_tmp_name_source("upb"),
  temporary = TRUE,
  allow_rqdatatable = TRUE
)

layout_to_blocks(
  data,
  nameForNewKeyColumn,
  nameForNewValueColumn,
  columnsToTakeFrom,
  ...,
  nameForNewClassColumn = NULL,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  tmp_name_source = wrapr::mk_tmp_name_source("upb"),
  temporary = TRUE,
  allow_rqdatatable = TRUE
)

pivot_to_blocks(
  data,
  nameForNewKeyColumn,
  nameForNewValueColumn,
  columnsToTakeFrom,
  ...,
  nameForNewClassColumn = NULL,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  tmp_name_source = wrapr::mk_tmp_name_source("upb"),
  temporary = TRUE,
  allow_rqdatatable = TRUE
)

\method{unpivot_to_blocks}{default}(
  data,
  nameForNewKeyColumn,
  nameForNewValueColumn,
  columnsToTakeFrom,
  ...,
  nameForNewClassColumn = NULL,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  allow_rqdatatable = TRUE
)

\method{unpivot_to_blocks}{relop}(
  data,
  nameForNewKeyColumn,
  nameForNewValueColumn,
  columnsToTakeFrom,
  ...,
  checkNames = TRUE,
  checkKeys = FALSE,
  strict = FALSE,
  nameForNewClassColumn = NULL,
  tmp_name_source = wrapr::mk_tmp_name_source("upb"),
  temporary = TRUE,
  allow_rqdatatable = TRUE
)
}
\arguments{
\item{data}{data.frame to work with.}

\item{nameForNewKeyColumn}{character name of column to write new keys in.}

\item{nameForNewValueColumn}{character name of column to write new values in.}

\item{columnsToTakeFrom}{character array names of columns to take values from.}

\item{...}{force later arguments to bind by name.}

\item{nameForNewClassColumn}{optional name to land original cell classes to.}

\item{checkNames}{logical, if TRUE check names.}

\item{checkKeys}{logical, if TRUE check columnsToCopy form row keys (not a requirement, unless you want to be able to invert the operation).}

\item{strict}{logical, if TRUE check control table name forms.}

\item{tmp_name_source}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{temporary}{logical, if TRUE make result temporary.}

\item{allow_rqdatatable}{logical, if TRUE allow rqdatatable shortcutting on simple conversions.}
}
\value{
new data.frame with values moved to rows.
}
\description{
Map a data records from row records (records that are exactly single rows) to block records
(records that may be more than one row).  All columns not named in columnsToTakeFrom are copied to each
record row in the result.
}
\examples{

  d <- data.frame(model_name = "m1", AUC = 0.6, R2 = 0.2)
  unpivot_to_blocks(d,
                    nameForNewKeyColumn= 'meas',
                    nameForNewValueColumn= 'val',
                    columnsToTakeFrom= c('AUC', 'R2')) \%.>\%
     print(.)


d <- data.frame(AUC= 0.6, R2= 0.2)
ops <- rquery::local_td(d) \%.>\%
  unpivot_to_blocks(
    .,
    nameForNewKeyColumn= 'meas',
    nameForNewValueColumn= 'val',
    columnsToTakeFrom= c('AUC', 'R2'))
cat(format(ops))

if(requireNamespace("rqdatatable", quietly = TRUE)) {
  library("rqdatatable")
  d \%.>\%
    ops \%.>\%
    print(.)
}

if(requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(db,
                    'd',
                    d,
                    overwrite = TRUE,
                    temporary = TRUE)
  db \%.>\%
    ops \%.>\%
    print(.)
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{pivot_to_rowrecs}}, \code{\link{rowrecs_to_blocks}}
}
