## ------------------------------------------------------------------------
d <- data.frame(
  names = c("a", "b", "c", "d"),
  x =     c(1,   2,   3,   4  ),
  y =     c(1,   4,   9,   16 ),
  stringsAsFactors = FALSE)

print(d)

## ------------------------------------------------------------------------
str(d)

## ------------------------------------------------------------------------
library("wrapr")

## ---- comment=''---------------------------------------------------------
cat(draw_frame(d))

## ------------------------------------------------------------------------
d2 <- build_frame(
   "names", "x", "y" |
   "a"    , 1  ,  1  |
   "b"    , 2  ,  4  |
   "c"    , 3  ,  9  |
   "d"    , 4  , 16  )

print(d2)

## ------------------------------------------------------------------------
build_frame(
   "names", "x", "y" |
   "a"    , 1  ,  1  ,
   "b"    , 2  ,  4  ,
   "c"    , 3  ,  9  ,
   "d"    , 4  , 16  )

## ---- comment=""---------------------------------------------------------
cat(dump("d", ""))

## ---- comment=""---------------------------------------------------------
cat(draw_frame(build_frame(
 "names", "x", "y" |
  "a", 1,  1,
  "b", 2,  4,
  "c", 3,  9,
  "d", 4, 16)))

## ------------------------------------------------------------------------
qchar_frame(
  col_1, col_2, col_3 |
  a    , b    , c     |
  d    , e    , "f g" )

## ------------------------------------------------------------------------
build_frame(
   "names", "x"     , "y" |
   "a"    , 1       ,  1  |
   "b"    , cos(2)  ,  4  |
   "c"    , (3+2)   ,  9  |
   "d"    , 4       , 16  )

