% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs.R
\name{get_cancer_hazard}
\alias{get_cancer_hazard}
\title{Get cancer hazard}
\usage{
get_cancer_hazard(
  DTXSID = NULL,
  API_key = NULL,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.frame of cancer hazard data related to the input DTXSID.
}
\description{
Get cancer hazard
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull cancer hazard data for BPA
bpa_cancer <- get_cancer_hazard(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
