% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustergscairls.r
\name{clustergscairls}
\alias{clustergscairls}
\title{Clustering gsc-models}
\usage{
clustergscairls(dat, B, indicatorx, indicatory, loadingx = FALSE,
  loadingy = FALSE, k, minmem = FALSE, wieder)
}
\arguments{
\item{dat}{(n,p)-matrix, the values of the manifest variables}

\item{B}{(q,q) lower triangular matrix describing the interrelations of the latent variables:
b_ij= 1 regression coefficient of eta_j in the regression relation in which eta_i is
b_ij= 0 if eta_i does not depend on eta_j in a direct way  (b_ii = 0 !)}

\item{indicatorx}{vector describing with which exogenous composite the X-variables are connected}

\item{indicatory}{vector describing with which endogenous composite the Y-variables are connected}

\item{loadingx}{logical TRUE when there are loadings for the X-variables in the model}

\item{loadingy}{logical TRUE when there are loadings for the Y-variables in the model}

\item{k}{scalar, the number of clusters to be found}

\item{minmem}{number of the cluster's members or FALSE (then ist is set to 2*number of indicators)}

\item{wieder}{scalar, the number of random starts}
}
\value{
out list with components
  \tabular{ll}{
              member \tab (n,1)-vector, indicator of membership  \cr
              Bhat \tab (k,q,q)-array, the path coefficients of the clusters \cr
              lambda \tab (p,k)-matrix, the loadings of the clusters \cr
              fitall \tab the total fit measure for the structural models only \cr
              fit \tab vector of length k, the fit values of the different models \cr
              R2 \tab (k,q) matrix, the coefficients of determination for the structural regression equations
              }
}
\description{
\code{clustergscairls} clusters data sets in that way that each cluster has a its own
 set of coefficients in the gsc-model.
}
\examples{
\donttest{ 
data(twoclm)
dat <- twoclm[,-10]
B <- matrix(c( 0,0,0, 0,0,0, 1,1,0),3,3,byrow=TRUE)
indicatorx <- c(1,1,1,2,2,2)
indicatory <- c(1,1,1)  
out <- clustergscairls(dat,B,indicatorx,indicatory,loadingx=FALSE,loadingy=FALSE,2,minmem=6,1) 
}
}
