% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{cbc_design}
\alias{cbc_design}
\title{Generate survey designs for choice experiments (Updated Implementation)}
\usage{
cbc_design(
  profiles,
  method = "random",
  priors = NULL,
  n_alts,
  n_q,
  n_resp = 100,
  n_blocks = 1,
  n_cores = NULL,
  no_choice = FALSE,
  label = NULL,
  randomize_questions = TRUE,
  randomize_alts = TRUE,
  remove_dominant = FALSE,
  dominance_types = c("total", "partial"),
  dominance_threshold = 0.8,
  max_dominance_attempts = 50,
  max_iter = 50,
  n_start = 5,
  include_probs = FALSE,
  use_idefix = TRUE
)
}
\arguments{
\item{profiles}{A data frame of class \code{cbc_profiles} created using \code{cbc_profiles()}}

\item{method}{Choose the design method: "random", "shortcut", "minoverlap", "balanced", "stochastic", "modfed", or "cea". Defaults to "random"}

\item{priors}{A \code{cbc_priors} object created by \code{cbc_priors()}, or NULL for random/shortcut designs}

\item{n_alts}{Number of alternatives per choice question}

\item{n_q}{Number of questions per respondent (or per block)}

\item{n_resp}{Number of respondents (for random/shortcut designs) or 1 (for optimized designs that get repeated)}

\item{n_blocks}{Number of blocks in the design. Defaults to 1}

\item{n_cores}{Number of cores to use for parallel processing in the design search.
Defaults to NULL, in which case it is set to the number of available cores minus 1.}

\item{no_choice}{Include a "no choice" option? Defaults to FALSE}

\item{label}{The name of the variable to use in a "labeled" design. Defaults to NULL}

\item{randomize_questions}{Randomize question order for each respondent? Defaults to TRUE (optimized methods only)}

\item{randomize_alts}{Randomize alternative order within questions? Defaults to TRUE (optimized methods only)}

\item{remove_dominant}{Remove choice sets with dominant alternatives? Defaults to FALSE}

\item{dominance_types}{Types of dominance to check: "total" and/or "partial"}

\item{dominance_threshold}{Threshold for total dominance detection. Defaults to 0.8}

\item{max_dominance_attempts}{Maximum attempts to replace dominant choice sets. Defaults to 50.}

\item{max_iter}{Maximum iterations for optimized designs. Defaults to 50}

\item{n_start}{Number of random starts for optimized designs. Defaults to 5}

\item{include_probs}{Include predicted probabilities in resulting design? Requires \code{priors}. Defaults to \code{FALSE}}

\item{use_idefix}{If \code{TRUE} (the default), the idefix package will be used to find optimal designs, which is faster.
Only valid with \code{"cea"} and \code{"modfed"} methods.}
}
\value{
A \code{cbc_design} object containing the experimental design
}
\description{
This function creates experimental designs for choice-based conjoint experiments
using multiple design approaches including optimization and frequency-based methods.
}
\details{
\subsection{Design Methods}{

The \code{method} argument determines the design approach used:
\itemize{
\item \code{"random"}: Creates designs by randomly sampling profiles for each respondent independently
\item \code{"shortcut"}: Frequency-based greedy algorithm that balances attribute level usage
\item \code{"minoverlap"}: Greedy algorithm that minimizes attribute overlap within choice sets
\item \code{"balanced"}: Greedy algorithm that maximizes overall attribute balance across the design
\item \code{"stochastic"}: Stochastic profile swapping with D-error optimization (first improvement found)
\item \code{"modfed"}: Modified Fedorov algorithm with exhaustive profile swapping for D-error optimization
\item \code{"cea"}: Coordinate Exchange Algorithm with attribute-by-attribute D-error optimization
}
}

\subsection{Method Compatibility}{

The table below summarizes method compatibility with design features:\tabular{lllllll}{
   Method \tab No choice? \tab Labeled designs? \tab Restricted profiles? \tab Blocking? \tab Interactions? \tab Dominance removal? \cr
   "random" \tab Yes \tab Yes \tab Yes \tab No \tab Yes \tab Yes \cr
   "shortcut" \tab Yes \tab Yes \tab Yes \tab No \tab No \tab Yes \cr
   "minoverlap" \tab Yes \tab Yes \tab Yes \tab No \tab No \tab Yes \cr
   "balanced" \tab Yes \tab Yes \tab Yes \tab No \tab No \tab Yes \cr
   "stochastic" \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \cr
   "modfed" \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \cr
   "cea" \tab Yes \tab Yes \tab No \tab Yes \tab Yes \tab Yes \cr
}

}

\subsection{Design Quality Assurance}{

All methods ensure the following criteria are met:
\enumerate{
\item No duplicate profiles within any choice set
\item No duplicate choice sets within any respondent
\item If \code{remove_dominant = TRUE}, choice sets with dominant alternatives are eliminated (optimization methods only)
}
}

\subsection{Method Details}{
\subsection{Random Method}{

Creates designs where each respondent sees completely independent, randomly generated choice sets.
}

\subsection{Greedy Methods (shortcut, minoverlap, balanced)}{

These methods use frequency-based algorithms that make locally optimal choices:
\itemize{
\item \strong{Shortcut}: Balances attribute level usage within questions and across the overall design
\item \strong{Minoverlap}: Minimizes attribute overlap within choice sets while allowing some overlap for balance
\item \strong{Balanced}: Maximizes overall attribute balance, prioritizing level distribution over overlap reduction
}

These methods provide good level balance without requiring priors or D-error calculations and offer fast execution suitable for large designs.
}

\subsection{D-Error Optimization Methods (stochastic, modfed, cea)}{

These methods minimize D-error to create statistically efficient designs:
\itemize{
\item \strong{Stochastic}: Random profile sampling with first improvement acceptance
\item \strong{Modfed}: Exhaustive profile testing for best improvement (slower but thorough)
\item \strong{CEA}: Coordinate exchange testing attribute levels individually (requires full factorial profiles)
}
}

}

\subsection{idefix Integration}{

When \code{use_idefix = TRUE} (the default), the function leverages the highly optimized
algorithms from the idefix package for 'cea' and 'modfed' design generation methods.
This can provide significant speed improvements, especially for larger
problems.

Key benefits of idefix integration:
\itemize{
\item Faster optimization algorithms with C++ implementation
\item Better handling of large candidate sets
\item Optimized parallel processing
\item Advanced blocking capabilities for multi-block designs
}
}
}
