% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_node.R
\name{dag_node}
\alias{dag_node}
\title{Add a node to an existing \code{causact_graph} object}
\usage{
dag_node(
  graph,
  descr = as.character(NA),
  label = as.character(NA),
  rhs = NA,
  child = as.character(NA),
  data = NULL,
  obs = FALSE,
  keepAsDF = FALSE,
  extract = as.logical(NA),
  dec = FALSE,
  det = FALSE
)
}
\arguments{
\item{graph}{a graph object of class \code{causact_graph}.  An initial object gets created using \code{dag_create()}.}

\item{descr}{a longer more descriptive character label for the node.}

\item{label}{a shorter character label for referencing the node (e.g. "X","beta").  Labels with \code{.} in the name will be replaced by \verb{_} to ensure inter-operability with Python.  Additionally, Python reserved words, like \code{lambda} should not be used.}

\item{rhs}{either a distribution such as \verb{uniform, normal, lognormal, bernoulli,} etc. or an R expression. Valid values include \code{normal(mu,sigma)}, \code{normal}, and \code{normal(6,2)}.  R computation/expression examples include \code{alpha+beta*x},\code{c(int, coefs)}, or \code{1 / exp(-(alpha + beta * x))}.  Concatenation using \code{c()} is NOT supported.  If a distribution is given, this is a random/stochastic node, if a formula is given it is a deterministic node once given the values of its parents.  Quotes should not be used as all function/computations should consist of R objects, functions, and constants.  Common R arithmetic and geometric operators are supported, but less common R expressions may yield errors when running \code{dag_numpyro()}.}

\item{child}{an optional character vector of existing node labels.  Directed edges from the newly created node to the supplied nodes will be created.}

\item{data}{a vector or data frame (with observations in rows and variables in columns).}

\item{obs}{a logical value indicating whether the node is observed.  Assumed to be \code{TRUE} when \code{data} argument is given.}

\item{keepAsDF}{a logical value indicating whether the \code{data} argument should be split into one random variable node per column or kept together as a random matrix for matrix computation.  Defaults to creating one node per column of the data frame.}

\item{extract}{a logical value.  When TRUE, child nodes will try to extract an indexed value from this node.  When FALSE, the entire random object (e.g. scalar, vector, matrix) is passed to children nodes.  Only use this argument when overriding default behavior seen using \code{dag_render()}.}

\item{dec}{a logical value indicating whether the node is a decision node.  Used to show nodes as rectangles instead of ovals when using \code{dag_render()}.}

\item{det}{a logical value indicating whether the node is a deterministic function of its parents  Used to draw a double-line (i.e. peripheries = 2) around a shape when using \code{dag_render()}.  Assumed to be \code{TRUE} when \code{rhs} is a formula.}
}
\value{
a graph object of class \code{causact_graph} with an additional node(s).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Add a node to an existing \code{causact_graph} object. The graph object should be of class \code{causact_graph} and created using \code{dag_create()}.
}
\examples{
# Create an empty graph and add 2 nodes by using
# the `dag_node()` function twice
graph2 = dag_create() \%>\%
  dag_node("Get Card","y",
         rhs = bernoulli(theta),
         data = carModelDF$getCard) \%>\%
  dag_node(descr = "Card Probability by Car",label = "theta",
           rhs = beta(2,2),
           child = "y")
graph2 \%>\% dag_render()


# The Eight Schools Example from Gelman et al.:

schools_dat <- data.frame(y = c(28,  8, -3,  7, -1,  1, 18, 12),
sigma = c(15, 10, 16, 11,  9, 11, 10, 18), schoolName = paste0("School",1:8))

graph = dag_create() \%>\%
  dag_node("Treatment Effect","y",
           rhs = normal(theta, sigma),
           data = schools_dat$y) \%>\%
  dag_node("Std Error of Effect Estimates","sigma",
           data = schools_dat$sigma,
           child = "y") \%>\%
  dag_node("Exp. Treatment Effect","theta",
           child = "y",
           rhs = avgEffect + schoolEffect) \%>\%
  dag_node("Pop Treatment Effect","avgEffect",
           child = "theta",
           rhs = normal(0,30)) \%>\%
  dag_node("School Level Effects","schoolEffect",
           rhs = normal(0,30),
           child = "theta") \%>\%
  dag_plate("Observation","i",nodeLabels = c("sigma","y","theta")) \%>\%
  dag_plate("School Name","school",
            nodeLabels = "schoolEffect",
            data = schools_dat$schoolName,
            addDataNode = TRUE)

graph \%>\% dag_render()
\dontrun{
# below requires Tensorflow installation
drawsDF = graph \%>\% dag_numpyro(mcmc=TRUE)
tidyDrawsDF \%>\% dagp_plot()
}
}
