% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_merge.R
\name{dag_merge}
\alias{dag_merge}
\title{Merge two non-intersect \code{causact_graph} objects}
\usage{
dag_merge(graph1, ...)
}
\arguments{
\item{graph1}{A causact_graph objects to be merged with}

\item{...}{As many causact_graph's as wish to be merged}
}
\value{
a merged graph object of class \code{causact_graph}.  Useful for creating simple graphs and then merging them into a more complex structure.
}
\description{
Generates a single \code{causact_graph} graph object that combines the multiple provided graphs.
}
\examples{
# With `dag_merge()` we
# reset the node ID's and all other item ID's,
# bind together the rows of all given graphs, and
# add in nodes and edges later
# with other functions
# to connect the graph.
#
# THE GRAPHS TO BE MERGED MUST BE DISJOINT
# THERE CAN BE NO IDENTICAL NODES OR PLATES
# IN EACH GRAPH TO BE MERGED, AT THIS TIME


g1 = dag_create() \%>\%
 dag_node("Demand for A","dA",
           rhs = normal(15,4)) \%>\%
  dag_node("Supply for A","sA",
           rhs = uniform(0,100)) \%>\%
  dag_node("Profit for A","pA",
           rhs = min(sA,dA)) \%>\%
  dag_edge(from = c("dA","sA"),to = c("pA"))


g2 <- dag_create() \%>\%
  dag_node("Demand for B","dB",
           rhs = normal(20,8)) \%>\%
  dag_node("Supply for B","sB",
           rhs = uniform(0,100)) \%>\%
  dag_node("Profit for B","pB",
           rhs = min(sB,dB)) \%>\%
  dag_edge(from = c("dB","sB"),to = c("pB"))

g1 \%>\% dag_merge(g2) \%>\%
  dag_node("Total Profit", "TP",
           rhs = sum(pA,pB)) \%>\%
  dag_edge(from=c("pA","pB"), to=c("TP")) \%>\%
  dag_render()
}
