% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_node.R
\name{join_node}
\alias{join_node}
\title{Node joiner}
\usage{
join_node(nodes, level, limit, tol, inters)
}
\arguments{
\item{nodes}{list of node lists. Every node list must contain the ID of the
node, the vector of density function values of the evaluated abiity levels,
the vector of previous items, the estimated ability level and the node
confluency}

\item{level}{level of the CAT decision tree}

\item{limit}{maximum number of level nodes}

\item{tol}{minimum distance between estimated ability levels to join two nodes}

\item{inters}{minimum common area between density functions in the nodes of
the evaluated pair in order to join them}
}
\value{
A list of node lists. This list is the input list updated with the
joined nodes
}
\description{
Given all the nodes from one level, \code{join_node} evaluates all possible
pairs one by one and decides whether or not to join them based on the
similarity between the estimated ability levels and the density functions.
If a pair of nodes is joined, the density function of the resulting node is
the mean of the density functions of the joined nodes and the confluencies
are summed.
}
\author{
Javier Rodríguez-Cuadrado
}
