% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_simulation.R
\name{setup_parms}
\alias{setup_parms}
\title{Parameter Setup}
\usage{
setup_parms(concept_def)
}
\arguments{
\item{concept_def}{Concept definition as a \code{c4c_concept} object}
}
\value{
A list with three elements. The first, \code{dwell_time}, is a vector
of dwell times for each subphase area, i.e. it indicates the average time a
unit area is dwelling in this subphase (assuming an exponential
distribution over time). The second element, \code{risk}, is a vector of
the same length and order. It represents, for each subphase area, the
average relative loss rate per year. It is derived from the cumulative
survival probabilities (\code{survival_com}) given in the data frame
\code{growth_and_yield} which is part of the concept definition
(\code{concept_def}). The third element, \code{phase_indexes}, is a tibble
which contains, for each stand development phase in \code{concept_def}, a
vector of indexes which can be used to easier access the phase wise
information in the different kinds of simulation outputs.
}
\description{
Given a \code{c4c_concept} concept definition, a list of parameter elements
is handed back. This information is required for simulations and subsequent
evaluations.
}
\details{
The element \code{risk} as part of the output describe as 'normal' risk as
assumed for the silvicultural concept defined in \code{concept_def}. This can
be adjusted with the parameter \code{avg_event_strength} of the function
\code{\link{setup_risk_events}}, which has to be called in any case after the
parameter setup.
}
\examples{
  parms <- pine_thinning_from_above_1 |> setup_parms()
  parms

}
