% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_twogrid_shift}
\alias{make_twogrid_shift}
\title{Generate Two Shifted Grid Clusters in High Dimensions}
\usage{
make_twogrid_shift(n = c(500, 500))
}
\arguments{
\item{n}{A numeric vector of length 2 specifying the number of points in each cluster.
Default is \code{c(500, 500)}.}
}
\value{
A tibble with \code{n[1] + n[2]} rows and 5 columns:
\itemize{
  \item \code{x1, x2, x3, x4}: Numeric coordinates of the points.
  \item \code{cluster}: Cluster membership label (factor with 2 levels).
}
}
\description{
This function generates two grid-shaped clusters in a 2D space, where one grid
is shifted relative to the other. Optionally, additional noise dimensions
can be added to embed the structure in a higher-dimensional space.
}
\examples{
# Generate 2 shifted grid clusters in 4-D
make_twogrid_shift <- make_twogrid_shift()


}
