% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{three_diff_linear}
\alias{three_diff_linear}
\title{Generate Three Different Linear Data with Noise}
\usage{
three_diff_linear(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the three different linear data with added noise.
}
\description{
This function generates a dataset consisting of three different linear
patterns with added noise.
}
\examples{
set.seed(20240412)
three_diff_linear <- three_diff_linear(
  n = 150, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
