% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clust_diff_shapes_pts}
\alias{clust_diff_shapes_pts}
\title{Generate Clusters with Different Shapes and Different Number of Points}
\usage{
clust_diff_shapes_pts(
  clust_size_vec,
  num_gau_clust,
  num_non_gau_clust,
  clust_sd_gau,
  clust_sd_non_gau,
  num_dims,
  a,
  b
)
}
\arguments{
\item{clust_size_vec}{A vector specifying the number of points for each cluster.}

\item{num_gau_clust}{The number of Gaussian clusters to generate.}

\item{num_non_gau_clust}{The number of non-Gaussian clusters to generate.}

\item{clust_sd_gau}{The standard deviation for the Gaussian clusters.}

\item{clust_sd_non_gau}{The standard deviation for the non-Gaussian clusters.}

\item{num_dims}{The number of dimensions for the data points.}

\item{a}{The scaling factor for the non-Gaussian cluster shape.}

\item{b}{The translation factor for the non-Gaussian cluster shape.}
}
\value{
A matrix containing the generated clusters with different shapes and
different numbers of points.
}
\description{
This function generates clusters with different shapes, including both Gaussian
and non-Gaussian clusters,
with different numbers of points in each cluster.
}
\examples{
# Generate clusters with default parameters
set.seed(20240412)
data <- clust_diff_shapes_pts(
  clust_size_vec = c(50, 50, 50, 50, 100, 100),
  num_gau_clust = 4,
  num_non_gau_clust = 2, clust_sd_gau = 0.05, clust_sd_non_gau = 0.1,
  num_dims = 7, a = 2, b = 4
)
}
