% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carbon_fields.R
\name{carbon_fields}
\alias{carbon_fields}
\alias{carbon-fields}
\title{Carbon object fields}
\arguments{
\item{code}{character, script to embbed, Default: NULL}

\item{palette}{numeric, layout pallete, Default: c(r=171,g=184,b=195,a=1)}

\item{template}{character, layout template, Default: 'seti'}

\item{add_window_control}{boolean, add/remove window controls (circles on top left corner),
Default: TRUE}

\item{window_control_theme}{character, change window control themes, Default: 'none'}

\item{language}{character, language, Default: 'r'}

\item{add_drop_shadow}{boolean, add/remove dropshadow, Default: TRUE}

\item{drop_shadow_offset_y}{numeric, shadow vertical offset (px), Default: 20}

\item{drop_shadow_blur_radius}{numeric, shadow blur radius (px), Default: 68}

\item{auto_adjust_width}{boolean, auto-audjust output width, Default: TRUE}

\item{padding_vertical}{numeric, vertical padding (px), Default: 48}

\item{padding_horizontal}{numeric, horizontal padding (px), Default: 32}

\item{add_line_number}{boolean, add/remove line numbers, Default: FALSE}

\item{font_family}{character, layout font family, Default: 'Hack'}

\item{font_size}{numeric, font size (px), Default: 14}

\item{line_height_percent}{numeric, relative space between lines (percent), Default: 133}

\item{square_image}{boolean, output image is square, Default: FALSE}

\item{relative_export_size}{numeric, image size in export relative to what is in
the preview (1,2 or 4), Default: 1}

\item{add_watermark}{boolean, add official carbon.js watermark, Default: FALSE}

\item{add_tinyurl}{boolean, add tinyurl link to image directing to the carbon page that
created the image, Default: FALSE}

\item{tinyurl_location}{character, string with \link[magick:options]{gravity} value to place the annotate tinyurl
address on image, Default: 'southeast'}

\item{tweet}{boolean, tweet out the image using \link[rtweet:post_tweet]{post_tweet}}

\item{tweet_status}{character, status to add to the tweet. If add_tinyurl is TRUE then
a link to the url will be appended to the status automatically,
Default: 'Created in R using the Carbonate (Package Icon)'}

\item{add_timestamp}{boolean, add timestamp to output filename, Default: FALSE}

\item{carbons}{list, storage of rendered carbon images, Default: NULL}

\item{download_path}{character, path to download the images, Default: tempdir()}

\item{chrome_args}{character, arguments passed to chrome browser, Default:
c('--disable-gpu', '--window-size=1280,800')}

\item{chrome_pref}{list, preferences passed to chrome browser, Default:
list("profile.default_content_settings.popups" = 0L,"download.prompt_for_download" = FALSE,"download.default_directory" = tempdir())}

\item{rD}{RSelenium Driver object}

\item{cDrv}{Chrome Driver object from wdman}
}
\description{
Fields that can be changed in the \link[=carbon]{Carbon} object
}
\seealso{
\link[=carbon]{carbon}
}
