% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapkmlPSU.R
\name{MapkmlPSU}
\alias{MapkmlPSU}
\title{Creates *.kml files of a subset of polygons from a polygon shapefile}
\usage{
MapkmlPSU(shape = NULL, psu = NULL, id = NULL, path = "./psu_maps/")
}
\arguments{
\item{shape}{string with the path of a polygon shapefile or an object of \code{\link{class}} \link[sf]{sf} (see examples).}

\item{psu}{polygons to subset.}

\item{id}{column of the *.dbf file with the values to be matched against.}

\item{path}{\code{\link{class}} character with the path in which maps will be saved. If the path already exists, it will be overwrited.}
}
\value{
*.kml files of the subsetted polygons.
}
\description{
Subset the polygons specified in \code{psu} and creates *.kml files of theses polygons.
}
\details{
If there are *.kml files in the working directory, the new created files will overwrite it in case of name matching.

\code{shape} must receive a shapefile with appropriate coordinate reference system, otherwise, \code{MapkmlPSU} report an error.
}
\examples{
data("psu_ssu")

# Take a sample of 5 PSU.
(selected_psu <- SamplePPS(psu.ssu = psu_ssu, psu = 5))
 
## Define shape from shapefile.
shp_path <- system.file("extdata/35SEE250GC_SIR.shp", package="capm")
# The code above used a shapefile avaliable in the
# capm package.
# You might want to write a code like:
# shp.path  <- 'path_to_the_folder_with_the_shapefile'
 
# Create *kml files of 10 polygons.
\dontrun{
MapkmlPSU(shape = shp_path,
         psu = selected_psu[, "selected_psu"],
         id = "CD_GEOCODI")

## Define the shape argument as an object x of class sf.
x <- read_sf(shp_path)
MapkmlPSU(shape = x, psu = selected_psu[, "selected_psu"], id = "CD_GEOCODI")
}

}
\references{
Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
