% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make_matrix.R
\name{constructDesignMatrix}
\alias{constructDesignMatrix}
\title{Generate a design matrix from raw RNAi data.}
\description{
This function takes the raw RNAi data as input and generates a design matrix for regression.  Specifically written for the format of the data set \code{\link{RNAi}}, which contains four batches.  This R function will use \code{batch3} as the baseline.
}
\usage{
constructDesignMatrix(data, covariates)
}
\arguments{
\item{data}{Matrix of RNAi measurements; includes columns batch, query_gene and template_gene.}
\item{covariates}{Vector of strings; each string is the name of a covariate.}
}
\value{
A design matrix.  The number of rows is the same as that of the data set \code{\link{RNAi}}, and the number of columns is the same as the length of \code{covariates}.
}
\examples{
## See example in documentation for the data set RNAi.
}
