% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_regions.R
\name{search_census_regions}
\alias{search_census_regions}
\title{Query the CensusMapper API for regions with names matching a searchterm.}
\usage{
search_census_regions(searchterm, dataset, level = NA, ...)
}
\arguments{
\item{searchterm}{The term to search for e.g. \code{"Victoria"}.
Search terms are case insensitive. If unable to find a given search term,
this function will suggest the correct spelling to use when possible.}

\item{dataset}{The dataset to query for available regions, e.g.
\code{"CA16"}.}

\item{level}{One of \code{NA}, \code{'C'}, \code{'PR'}, \code{'CMA'}, \code{'CD'}, or \code{'CSD'}.
If specified, only return variables of specified `level`.}

\item{...}{Further arguments passed on to \code{\link{list_census_regions}}.}
}
\description{
Runs a query against the CensusMapper API to retrieve region data with
names matching specific queries. Users can optionally specify the target geography level
(e.g. \code{level = 'CMA'}, \code{level = 'CSD'}, etc.). Alternatively, calling
\code{explore_census_vectors()} will launch the interactive region selection tool on
the Censusmapper site in a new web page or tab.
}
\examples{

\dontrun{
search_census_regions('Victoria', 'CA16')
# This will return a warning that no match was found, but will suggest similar named regions.
search_census_regions('Victorea', 'CA16')

# This will limit region results to only include CMA level regions
search_census_regions('Victoria', 'CA16', level = "CMA")
}
}
