% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{count_out}
\alias{count_out}
\title{Count out}
\usage{
count_out(x, y, na.rm = TRUE, ignore.case = FALSE)
}
\arguments{
\item{x}{A vector to check.}

\item{y}{A vector to compare against.}

\item{na.rm}{logical; Should \code{NA} be ignored?}

\item{ignore.case}{logical; if \code{FALSE}, the pattern matching is case
sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
The sum of \code{x} absent in \code{y}.
}
\description{
Count the total values of \code{x} that are are \verb{\%out\%} of the vector \code{y}.
}
\details{
\code{sum(x \%out\% y)}
}
\examples{
count_out(c("VT", "NH", "ZZ", "ME"), state.abb)
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_vec}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_in}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
