% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateAVE}
\alias{calculateAVE}
\title{Average variance extracted (AVE)}
\usage{
calculateAVE(
 .object              = NULL,
 .only_common_factors = TRUE
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality criteria:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}
}
\value{
A named vector of numeric values (the AVEs). If \code{.object} is a list
of \code{cSEMResults} objects, a list of AVEs is returned.
}
\description{
Calculate the average variance extracted (AVE) as proposed by
\insertCite{Fornell1981;textual}{cSEM}. For details see the
\href{https://floschuberth.github.io/cSEM/articles/Using-assess.html#ave}{cSEM website}
}
\details{
The AVE is inherently tied to the common factor model. It is therefore
unclear how to meaningfully interpret the AVE in the context of a
composite model. It is possible, however, to force computation of the AVE for constructs
modeled as composites by setting \code{.only_common_factors = FALSE}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
