% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateHTMT}
\alias{calculateHTMT}
\title{HTMT}
\usage{
calculateHTMT(
 .object               = NULL,
 .absolute             = TRUE,
 .alpha                = 0.05,
 .ci                   = c("CI_percentile", "CI_standard_z", "CI_standard_t", 
                           "CI_basic", "CI_bc", "CI_bca", "CI_t_interval"),
 .handle_inadmissibles = c("drop", "ignore", "replace"),
 .inference            = FALSE,
 .only_common_factors  = TRUE,
 .R                    = 499,
 .seed                 = NULL,
 ...
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.absolute}{Logical. Should the absolute HTMT values be returned?
Defaults to \code{TRUE} .}

\item{.alpha}{A numeric value giving the significance level.
Defaults to \code{0.05}.}

\item{.ci}{A character strings naming the type of confidence interval to use
to compute the 1-alpha\% quantile of the bootstrap HTMT values. For possible
choices see \code{\link[=infer]{infer()}}. Ignored
if \code{.inference = FALSE}. Defaults to "\emph{CI_percentile}".}

\item{.handle_inadmissibles}{Character string. How should inadmissible results
be treated? One of "\emph{drop}", "\emph{ignore}", or "\emph{replace}". If "\emph{drop}", all
replications/resamples yielding an inadmissible result will be dropped
(i.e. the number of results returned will potentially be less than \code{.R}).
For "\emph{ignore}" all results are returned even if all or some of the replications
yielded inadmissible results (i.e. number of results returned is equal to \code{.R}).
For "\emph{replace}" resampling continues until there are exactly \code{.R} admissible solutions.
Depending on the frequency of inadmissible solutions this may significantly increase
computing time. Defaults to "\emph{drop}".}

\item{.inference}{Logical. Should critical values be computed? Defaults to \code{FALSE}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality critera:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}

\item{.R}{Integer. The number of bootstrap replications. Defaults to \code{499}.}

\item{.seed}{Integer or \code{NULL}. The random seed to use. Defaults to \code{NULL} in which
case an arbitrary seed is chosen. Note that the scope of the seed is limited
to the body of the function it is used in. Hence, the global seed will
not be altered!}

\item{...}{Ignored.}
}
\value{
A lower tringular matrix of HTMT values. If \code{.inference = TRUE}
the upper tringular part is the 1-.alpha\%-quantile of the HTMT's bootstrap
distribution.
}
\description{
Compute the heterotrait-monotrait ratio of correlations (HTMT) based on
\insertCite{Henseler2015;textual}{cSEM}. The HTMT is a consistent estimator for the
construct correlations of a tau-equivalent measurement model. It is used to
assess discriminant validity.
}
\details{
Computation of the HTMT assumes that all intra-block and inter-block
correlations between indicators are either all-positive or all-negative.
A warning is given if this is not the case. If all intra-block or inter-block
correlations are negative the absolute HTMT values are returned (\code{.absolute = TRUE}).

To obtain the 1-alpha\%-quantile of the bootstrap distribution for each HTMT
value set \code{.inference = TRUE}. To choose the type of confidence interval to use
to compute the 1-alpha\%-quantile, use \code{.ci}. To control the bootstrap process,
arguments \code{.handle_inadmissibles}, \code{.R} and \code{.seed} are available.

Since the HTMT is defined with respect to a classical true score measurement
model only concepts modeled as common factors are considered by default.
For concepts modeled as composites the HTMT may be computed by setting
\code{.only_common_factors = FALSE}, however, it is unclear how to
interpret values in this case.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{csem}, \link{cSEMResults}
}
