% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateAVE}
\alias{calculateAVE}
\title{Internal: AVE}
\usage{
calculateAVE(
 .object              = NULL,
 .only_common_factors = TRUE
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality critera:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}
}
\value{
A named vector of numeric values of length equal to the number of constructs
in the model.
}
\description{
Calculate the average variance extracted (AVE) as proposed by
\insertCite{Fornell1981;textual}{cSEM}. For details see the
\href{https://m-e-rademaker.github.io/cSEM/articles/Using-assess.html#ave}{cSEM website}
}
\details{
The AVE is inherently tied to the common factor model. It is therefore
unclear how to meaningfully interpret AVE results in the context of a
composite model. It is possible to report the AVE for composites by
setting \code{.only_common_factors = FALSE},
however, result should be interpreted with caution
as they may not have a conceptual meaning.

The function is only applicable to objects inheriting class \code{cSEMResults_default}.
For objects of class \code{cSEMResults_multi} and \code{cSEMResults_2ndorder} use \code{\link[=assess]{assess()}}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
\keyword{internal}
