% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.plots.R
\name{cor_venn_diagram}
\alias{cor_venn_diagram}
\title{Venn Diagram of microRNA or transcription factor correlated features}
\usage{
cor_venn_diagram(ob, study, ...)
}
\arguments{
\item{ob}{A \link{cmicroRNA} or \link{cTF} object such as this returned by
calling \link{cmicroRNA} or \link{cTF}.}

\item{study}{A \code{character} vector of The Cancer Genome Atlas (TCGA)
study identifiers. To view the available studies in TCGA project,
\url{https://tcga-data.nci.nih.gov/docs/publications/tcga}. When left to
default \code{NULL} all available studies will be included.}

\item{...}{Other options}
}
\value{
A venn diagram with a circle or an ellipses for each microRNA and
the number of correlated features.
}
\description{
Count and plot the numbers of microRNA correlated features in
\code{cmicroRNA} object.
}
\examples{
# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- RSQLite::dbConnect(RSQLite::SQLite(), fl)

# enter a custom query with different arguments
dat <- get_mir(conn,
               mir = c('hsa-let-7g', 'hsa-let-7i'),
               study = 'STES')

# make a cmicroRNA object   
cmir <- cmicroRNA(dat)

# make graph
cor_venn_diagram(cmir)

}
