% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cOde.R
\name{funC}
\alias{funC}
\title{Generate C code for a function and compile it}
\usage{
funC(f, forcings = NULL, jacobian = FALSE, boundary = NULL,
  compile = TRUE, nGridpoints = 500, modelname = NULL)
}
\arguments{
\item{f}{Named character vector containing the right-hand sides of the ODE}

\item{forcings}{Character vector with the names of the forcings}

\item{jacobian}{Logical indicating whether the jacobian is computed and written into the C file}

\item{boundary}{data.frame with columns name, yini, yend specifying the boundary condition set-up. NULL if not a boundary value problem}

\item{compile}{Logical. If FALSE, only the C file is written}

\item{nGridpoints}{Integer, defining the number of grid points between tmin and tmax where the ODE
is computed in any case.}

\item{modelname}{Character. The C file is generated in the working directory and is named <modelname>.c.
If \code{NULL}, a random name starting with ".f" is chosen, i.e. the file is hidden on a UNIX system.}
}
\value{
the name of the generated shared object file together with a number of attributes
}
\description{
Generate C code for a function and compile it
}
\details{
The function replaces variables by arrays \code{y[i]}, etc. and replaces "^" by pow()
in order to have the correct C syntax. The file name of the C-File is derived from \code{f}.
I.e. \code{funC(abc, ...} will generate a file abc.c in the current directory.
Currently, only explicit ODE specification is supported, i.e. you need to have the right-hand sides of the ODE.
In case you have explicitly time-dependent ODEs, please introduce time t as explicit variable, e.g. \code{f <- c(t = "1", x = "a*t - x", ...)}.
}
\examples{
# Exponential decay plus constant supply
f <- c(x = "-k*x + supply")
func <- funC(f, forcings = "supply")
}

