% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rwishart}
\alias{rwishart}
\title{Generate Random Wishart Distribution}
\usage{
rwishart(df, S)
}
\arguments{
\item{df}{An \code{int}, which gives the degrees of freedom of the Wishart.  (> 0)}

\item{S}{A \code{matrix} with dimensions m x m that provides Sigma, the covariance matrix.}
}
\value{
A \code{matrix} that is a Wishart distribution, aka the sample covariance matrix of a Multivariate Normal Distribution
}
\description{
Creates a random wishart distribution when given degrees of freedom and a sigma matrix.
}
\examples{
#Call with the following data:
rwishart(3, diag(2))

# Validation
set.seed(1337)
S = toeplitz((10:1)/10)
n = 10000
o = array(dim = c(10,10,n))
for(i in 1:n){
o[,,i] = rwishart(20, S)
}
mR = apply(o, 1:2, mean)
Va = 20*(S^2 + tcrossprod(diag(S)))
vR = apply(o, 1:2, var)
stopifnot(all.equal(vR, Va, tolerance = 1/16))
}
\seealso{
\code{\link{riwishart}} and \code{\link{probitHLM}}
}
\author{
James J Balamuta
}
