% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_library.R
\name{ZoteroLibrary}
\alias{ZoteroLibrary}
\title{Access the Zotero library}
\usage{
ZoteroLibrary(
  zotero,
  case.insensitive = TRUE,
  ancestor = FALSE,
  recursive = FALSE,
  create = FALSE,
  limit = 100,
  start = 0,
  get.items = TRUE,
  item.type = NULL,
  all.results = TRUE,
  max.results = NULL,
  result.type = NULL,
  include.bib = FALSE,
  style = "apa",
  force = FALSE,
  silent = FALSE
)
}
\arguments{
\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items)}

\item{case.insensitive}{Disregard letter casing when searching for
collections, Default: TRUE}

\item{ancestor}{Trace the lineage of a collection (i.e., find the top-level
collection), Default: FALSE}

\item{recursive}{Find all nested collections, Default: FALSE}

\item{create}{Create missing collections, Default: FALSE}

\item{limit}{Number of results per query (max 100), Default: 100}

\item{start}{Starting position of query (0 = first result), Default: 0}

\item{get.items}{Fetch items along with collections, Default: TRUE}

\item{item.type}{Items to search for (NULL = everything), Default: NULL}

\item{all.results}{Find all results in query, Default: TRUE}

\item{max.results}{Do you need a limit?, Default: NULL}

\item{result.type}{Pointless linguistics to display result type (default =
`result`), Default: NULL}

\item{include.bib}{Include HTML-formatted bibliography from Zotero, Default:
FALSE}

\item{style}{Citation style to use for appended bibliography and/or
citations, Default: apa}

\item{force}{Force is seldom wise, but sometimes..., Default: FALSE}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}
}
\value{
A list with information on the specified Zotero library (e.g.,
  collections and items)
}
\description{
The function uses information stored in the `zotero` list to
  access specified collections and items in the Zotero library
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Access the default group library
  example <- ZoteroLibrary(
    Zotero(
      user = FALSE,
      id = "4827927",
      api = "RqlAmlH5l1KPghfCseAq1sQ1"
    )
  )

  # Print index using `ZoteroIndex`
  ZoteroIndex(example$items) |>
    dplyr::select(name) |>
    print(width = 80)
}
}
\seealso{
\code{\link[jsonlite]{toJSON, fromJSON}}
 \code{\link[dplyr]{distinct}}, \code{\link[dplyr]{arrange}}
 \code{\link[tibble]{tibble}}
}
