% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inclusion_prior.R
\name{inclusion_prior}
\alias{inclusion_prior}
\title{Prior Inclusion Probabilities}
\usage{
inclusion_prior(
  object,
  prob = 0.5,
  exclude_deterministics = TRUE,
  minnesota_like = FALSE,
  kappa = c(0.8, 0.5, 0.5, 0.8)
)
}
\arguments{
\item{object}{an object of class \code{"bvarmodel"}, usually, a result of a call to \code{\link{gen_var}}
or \code{\link{gen_vec}}.}

\item{prob}{a numeric specifying the prior inclusion probability of all model parameters.}

\item{exclude_deterministics}{logical. If \code{TRUE} (default), the vector of the positions of
included variables does not include the positions of deterministic terms.}

\item{minnesota_like}{logical. If \code{TRUE}, the prior inclusion probabilities of the
parameters are calculated in a similar way as the Minnesota prior. See 'Details'.}

\item{kappa}{a numeric vector of four elements containing the prior inclusion probabilities
of coefficients that correspond to own lags of endogenous variables, to endogenous variables,
which do not correspond to own lags, to exogenous variables and deterministic terms, respectively.
Only used if \code{minnesota_like = TRUE}. See 'Details'.}
}
\value{
A list containing a matrix of prior inclusion probabilities and an integer vector
specifying the positions of variables, which should be included in the variable selction algorithm.
}
\description{
Prior inclusion probabilities as required for stochastic search variable selection (SSVS) à la
George et al. (2008) and Bayesian variable selection (BVS) à la Korobilis (2013).
}
\details{
If \code{minnesota_like = TRUE}, prior inclusion probabilities \eqn{\underline{\pi}_1}
are calculated as
\tabular{cl}{
\eqn{\frac{\kappa_1}{r}} \tab for own lags of endogenous variables, \cr
\eqn{\frac{\kappa_2}{r}} \tab for other endogenous variables, \cr
\eqn{\frac{\kappa_3}{1 + r}} \tab for exogenous variables, \cr
\eqn{\kappa_{4}} \tab for deterministic variables, 
}
for lag \eqn{r} with \eqn{\kappa_1}, \eqn{\kappa_2}, \eqn{\kappa_3}, \eqn{\kappa_4} as the first, second,
third and forth element in \code{kappa}, respectively.

For vector error correction models the function generates prior inclusion probabilities for differenced
variables and unrestricted deterministc terms as described above. For variables in the error
correction term prior inclusion probabilites are calculated as
\tabular{cl}{
\eqn{\kappa_1} \tab fow own levels of endogenous variables, \cr
\eqn{\kappa_2} \tab for levels of other endogenous variables, \cr
\eqn{\kappa_3} \tab for levels of exogenous variables, \cr
\eqn{\kappa_4} \tab for deterministic variables.
}
}
\examples{

# Prepare data
data("e1")
data <- diff(log(e1))

# Generate model input
object <- gen_var(data)

# Obtain inclusion prior
pi_prior <- inclusion_prior(object)

}
\references{
George, E. I., Sun, D., & Ni, S. (2008). Bayesian stochastic search for VAR model
restrictions. \emph{Journal of Econometrics, 142}(1), 553--580.
\url{https://doi.org/10.1016/j.jeconom.2007.08.017}

Korobilis, D. (2013). VAR forecasting using Bayesian variable selection.
\emph{Journal of Applied Econometrics, 28}(2), 204--230. \url{https://doi.org/10.1002/jae.1271}
}
