% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burgle_flexsurv.R, R/predict_burgle.R
\name{predict_burgle}
\alias{predict_burgle}
\alias{predict.burgle_flexsurvreg}
\alias{predict.burgle_lm}
\alias{predict.burgle_glm}
\alias{predict.burgle_coxph}
\alias{predict.burgle_CauseSpecificCox}
\title{Predict for burgle methods}
\usage{
\method{predict}{burgle_flexsurvreg}(
  object,
  newdata = NA,
  original = FALSE,
  draws = 1,
  sims = 1,
  type = "lp",
  times = NULL,
  ...
)

\method{predict}{burgle_lm}(
  object,
  newdata,
  original = FALSE,
  draws = 1,
  sims = 1,
  type = "lp",
  se = FALSE,
  ...
)

\method{predict}{burgle_glm}(
  object,
  newdata,
  original = FALSE,
  draws = 1,
  sims = 1,
  type = "lp",
  se = FALSE,
  ...
)

\method{predict}{burgle_coxph}(
  object,
  newdata = NA,
  original = FALSE,
  draws = 1,
  sims = 1,
  type = "lp",
  times = NULL,
  ...
)

\method{predict}{burgle_CauseSpecificCox}(
  object,
  newdata = NULL,
  type = "lp",
  cause = 1,
  original = FALSE,
  draws = 1,
  sims = 1,
  times = NULL,
  ...
)
}
\arguments{
\item{object}{the results of burgle_lm object}

\item{newdata}{new data}

\item{original}{whether or not to predict using the original model}

\item{draws}{how many different models to simulate}

\item{sims}{how many simulated response to draw}

\item{type}{either 'lp', 'response', 'link' for glm or 'risk' if time dependent}

\item{times}{if type = "risk" time for which to predict risk, if times and sims is multiple the return will be lists within lists}

\item{...}{for future methods}

\item{se}{whether or not to include the standard error in the simulations}

\item{cause}{which cause do you want to predict}
}
\value{
either a matrix of array of new model predictions
}
\description{
Predict for burgle methods
}
