% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_luftqualitaet.R
\name{luftqualitaet_airquality}
\alias{luftqualitaet_airquality}
\title{List air quality measurements}
\usage{
luftqualitaet_airquality(params = list(), safe = TRUE, refresh = FALSE)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with air quality data.
}
\description{
List air quality measurements
}
\details{
The Luftqualitaet API provides air quality data and metadata from the
Umweltbundesamt. Use query parameters to filter by date/time and station.
Official docs: https://luftqualitaet.api.bund.dev.
}
\examples{
\dontrun{
luftqualitaet_airquality(params = list(
  date_from = "2024-01-01",
  date_to = "2024-01-02"
))
}

}
\seealso{
\code{\link[=luftqualitaet_measures]{luftqualitaet_measures()}} for measurement metadata and
\code{\link[=luftqualitaet_components]{luftqualitaet_components()}} for pollutant components.
}
