% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_nina.R
\name{nina_warning}
\alias{nina_warning}
\title{Get a NINA travel warning by content id}
\usage{
nina_warning(content_id, safe = TRUE, refresh = FALSE)
}
\arguments{
\item{content_id}{Travel warning content id.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with warning details.

Includes \code{last_modified_time} and \code{effective_time} as POSIXct in Europe/Berlin.
}
\description{
Get a NINA travel warning by content id
}
\details{
Returns full travel warning content, including HTML blocks.
}
\examples{
\dontrun{
warnings <- nina_warnings()
nina_warning(warnings$content_id[[1]])
}

}
\seealso{
\code{\link[=nina_warnings]{nina_warnings()}} for ids.
}
