% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_diga.R
\name{diga_device_definitions}
\alias{diga_device_definitions}
\title{List DiGA device definitions}
\usage{
diga_device_definitions(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to expand list-columns into multiple rows.}
}
\value{
A tibble containing DiGA device definitions from the FHIR API. When
\code{flatten = FALSE}, nested FHIR resource elements are preserved as list
columns. When \code{flatten = TRUE}, list columns are expanded based on the
specified \code{flatten_mode}.
}
\description{
List DiGA device definitions
}
\examples{
\dontrun{dig_device_definitions()}
}
