% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notch_estimator.R
\name{notch_estimator}
\alias{notch_estimator}
\title{Analyzing Bunching at a Notch}
\usage{
notch_estimator(earnings, zstar, t1, t2, Tax = 0, cf_start = NA,
  cf_end = NA, exclude_before = NA, exclude_after = NA, binw = 10,
  poly_size = 7, convergence = 0.01, max_iter = 100, select = TRUE,
  draw = FALSE)
}
\arguments{
\item{earnings}{Vector of earnings, hopefully a very large one}

\item{zstar}{Place of kink (critical earning point)}

\item{t1}{Tax rate before kink}

\item{t2}{Tax rate after kink}

\item{Tax}{"Penalty" tax for crossing zstar.}

\item{cf_start}{Number of bins before the kink bin where counter-factual
histogram should start.}

\item{cf_end}{Number of bins after the kink bin where counter-factual
histogram should start.}

\item{exclude_before}{Number of excluded bins before the kink bin.}

\item{exclude_after}{Number of excluded bins after the kink bin.}

\item{binw}{Bin width.}

\item{poly_size}{Order of polynomial used to calculate counter-factual
histogram.}

\item{convergence}{Minimal rate of change of bunching estimate to stop
iterations.}

\item{max_iter}{Maximum number of iterations for bunching estimates.}

\item{select}{Should model selection be used to find counter-factual
histogram? See details.}

\item{draw}{Should a graph be drawn?}
}
\value{
\code{notch_estimator } returns a list of the following variables:
\describe{
  \item{\code{e}}{Estimated elasticity}
  \item{\code{Bn}}{The sum of total estimated extra bunching in the area starting
  at cf_start and through the notch bin (zstar) }
  \item{\code{notch_size}}{Distance between notch bin and bin where the estimated
  influence of the notch ends, delta_zed}
  \item{\code{data}}{A data frame with bin mids, counts, counter-factual
  counts, and excluded dummy}
}
}
\description{
Given a kinked budget set, this function gets a vector of earnings and
analyzes bunching. This function could be run independently, but best used
through the \code{bunch} function.
}
\details{
A histogram is created from the earnings vector, with the kink
point zstar as the center of one of the bins.

For "unpure" notches, where the marginal tax rate after the notch is different
than the one before it, this function disregards the shifting of post-notch
distribution to the right, as suggested by Kleven (2016). Asssumption is that
the notch effect is much stronger anyway.

Model selection works using the \code{step} function from the stats package.
It runs backwards from the full polynomial model, trying to find the best
explanatory model using the Akaike information criterion.
}
\examples{
ability_vec <- 4000 * rbeta(100000, 2, 5)
earning_vec <- sapply(ability_vec, earning_fun, 0.2, 0.2, 0.2, 500, 1000)
bunch_viewer(earning_vec, 1000, 15, 30, 2, 21, binw = 50)
notch_estimator(earning_vec, 1000, 0.2, 0.2, 500, 15, 30, 2, 21, 50,
draw = FALSE)$e

}
\references{
Kleven, H J (2016). \emph{Bunching}, Annual Review of Economics,
8(1).
}
\seealso{
\code{\link{bunch}}, \code{\link{kink_estimator}}
}

