% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/look_for.R
\name{look_for}
\alias{look_for}
\title{Look for keywords variable names and descriptions in labelled data}
\usage{
look_for(
  data,
  ...,
  labels = TRUE,
  values = TRUE,
  ignore.case = TRUE,
  details = c("basic", "none", "full")
)
}
\arguments{
\item{data}{a data frame or a survey object}

\item{...}{optional list of keywords, a character string (or several
character strings), which can be formatted as a regular expression suitable
for a \code{\link[base:grep]{base::grep()}} pattern, or a vector of keywords;
displays all variables if not specified}

\item{labels}{whether or not to search variable labels (descriptions);
\code{TRUE} by default}

\item{values}{whether or not to search within values (factor levels or value
labels); \code{TRUE} by default}

\item{ignore.case}{whether or not to make the keywords case sensitive;
\code{TRUE} by default (case is ignored during matching)}

\item{details}{add details about each variable (full details could be time
consuming for big data frames, \code{FALSE} is equivalent to \code{"none"}
and \code{TRUE} to \code{"full"})}
}
\value{
A tibble data frame featuring the variable position, name and description (if it exists) in the original data frame.
}
\description{
The \code{look_for()} function is designed to emulate the functionality of the Stata \code{lookfor} command in R. It provides a powerful tool for searching through large datasets, specifically targeting variable names, variable label descriptions, factor levels, and value labels. This function is handy for users working with extensive and complex datasets, enabling them to quickly and efficiently locate the variables of interest.
}
\examples{

look_for(iris)

# Look for a single keyword.

look_for(iris, "petal")

look_for(iris, "s")

}
